﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Mouse.Sample3
{
    public partial class FormMain : Form
    {
        public enum IDCStandardCursors
        {
            IDC_Arrow = 0x7F00,
            IDC_Ibeam = 0x7F01,
            IDC_Wait = 0x7F02,
            IDC_Cross = 0x7F03,
            IDC_UpArrow = 0x7F04,
            IDC_Size = 0x7F80,
            IDC_Icon = 0x7F81,
            IDC_SizeNWSE = 0x7F82,
            IDC_SizeNESW = 0x7F83,
            IDC_SizeWE = 0x7F84,
            IDC_SizeNS = 0x7F85,
            IDC_SizeAll = 0x7F86,
            IDC_No = 0x7F88,
            IDC_Hand = 0x7F89,
            IDC_AppStarting = 0x7F8A,
            IDC_Help = 0x7F8B
        }

        [DllImport("user32.dll")]
        public static extern IntPtr LoadCursor(IntPtr hInstance, int lpCursorName);

        [DllImport("user32.dll")]
        public static extern IntPtr LoadCursorFromFile(string lpFileName);

        [DllImport("user32.dll")]
        public static extern bool SetSystemCursor(IntPtr hCur, int id);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonChangeCursor_Click(object sender, EventArgs e)
        {
            IntPtr hCrossCursor = LoadCursor(IntPtr.Zero, (int)IDCStandardCursors.IDC_Cross);
            SetSystemCursor(hCrossCursor, (int)IDCStandardCursors.IDC_Arrow);

            OpenFileDialog selectFile = new OpenFileDialog();
            if (selectFile.ShowDialog() == DialogResult.OK)
            {
                IntPtr hSelectCursor = LoadCursorFromFile(selectFile.FileName);
                SetSystemCursor(hSelectCursor, (int)IDCStandardCursors.IDC_SizeAll);
            }
        }
    }
}